<?php
/**
 * Plugin Name:           AutomatorWP - BuddyPress
 * Plugin URI:            https://automatorwp.com/add-ons/buddypress/
 * Description:           Connect AutomatorWP with BuddyPress.
 * Version:               1.5.3
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-buddypress
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.9
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\BuddyPress
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_BuddyPress {

    /**
     * @var         AutomatorWP_BuddyPress $instance The one true AutomatorWP_BuddyPress
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_BuddyPress self::$instance The one true AutomatorWP_BuddyPress
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_BuddyPress();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_BUDDYPRESS_VER', '1.5.3' );

        // Plugin file
        define( 'AUTOMATORWP_BUDDYPRESS_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_BUDDYPRESS_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_BUDDYPRESS_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Includes
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/ajax-functions.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/custom-tables.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/functions.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/tags.php';

            // Triggers
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/triggers/register-specific-field-value.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/triggers/account-activation.php';
            // BuddyPress Profile
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/triggers/update-avatar.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/triggers/update-cover.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/triggers/update-profile.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/triggers/specific-profile-field-value.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/triggers/update-member-type.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/triggers/mark-user-spam.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/triggers/unmark-user-spam.php';
            // BuddyPress Friendships
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/triggers/send-friendship.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/triggers/accept-friendship.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/triggers/get-friendship-accepted.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/triggers/reject-friendship.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/triggers/get-friendship-rejected.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/triggers/remove-friendship.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/triggers/get-friendship-removed.php';
            // BuddyPress Messages
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/triggers/send-message.php';
            // BuddyPress Activity
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/triggers/publish-activity.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/triggers/comment-activity.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/triggers/favorite-activity.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/triggers/get-favorite-activity.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/triggers/delete-comment-activity.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/triggers/spam-activity.php';
            // BuddyPress Groups
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/triggers/publish-group-activity.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/triggers/comment-activity-group.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/triggers/get-comment-activity-group.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/triggers/create-group.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/triggers/delete-group.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/triggers/join-group.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/triggers/join-group-type.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/triggers/invite-group.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/triggers/invite-group-type.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/triggers/request-join-private-group.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/triggers/request-join-private-group-type.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/triggers/join-private-group.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/triggers/join-private-group-type.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/triggers/reject-private-group.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/triggers/reject-private-group-type.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/triggers/leave-group.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/triggers/leave-group-type.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/triggers/removed-group.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/triggers/removed-group-type.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/triggers/banned-group.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/triggers/banned-group-type.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/triggers/user-group-role-changed.php';

            // Actions
            // BuddyPress Profile
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/actions/set-user-member-type.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/actions/update-user-profile-field.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/actions/mark-user-spam.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/actions/unmark-user-spam.php';
            // BuddyPress Activity
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/actions/add-user-activity.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/actions/add-group-activity.php';
            // BuddyPress Notifications
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/actions/add-user-notification.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/actions/add-group-notification.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/actions/add-group-roles-notification.php';
            // BuddyPress Messages
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/actions/send-user-message.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/actions/send-group-message.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/actions/send-group-roles-message.php';
            // BuddyPress Groups
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/actions/create-new-group.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/actions/add-user-group.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/actions/remove-user-group.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/actions/send-group-email.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/actions/send-group-roles-email.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/actions/create-new-subgroup.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/actions/accept-user-group-request.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/actions/reject-user-group-request.php';
            // BuddyPress Friendships
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/actions/user-friendship.php';

            // Filters
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/filters/user-member-type.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/filters/user-profile-field.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/filters/user-in-group-role.php';
            require_once AUTOMATORWP_BUDDYPRESS_DIR . 'includes/filters/user-not-in-group-role.php';

        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        // Setup our activation and deactivation hooks
        register_activation_hook( __FILE__, array( $this, 'activate' ) );
        register_deactivation_hook( __FILE__, array( $this, 'deactivate' ) );
        

        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'buddypress', array(
            'label' => 'BuddyPress',
            'icon'  => AUTOMATORWP_BUDDYPRESS_URL . 'assets/buddypress.svg',
        ) );

    }

    /**
     * Activation hook for the plugin.
     *
     * @since  1.0.0
     */
    function activate() {

        if( $this->meets_requirements() ) {

        }

    }

    /**
     * Deactivation hook for the plugin.
     *
     * @since  1.0.0
     */
    function deactivate() {

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        if ( ! class_exists( 'BuddyPress' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_BuddyPress instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_BuddyPress The one true AutomatorWP_BuddyPress
 */
function AutomatorWP_BuddyPress() {
    return AutomatorWP_BuddyPress::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_BuddyPress' );
